/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.recordingconfiguration;

import com.jrockit.mc.flightrecorder.EventAppearance;
import com.jrockit.mc.flightrecorder.configuration.IRecordingConfiguration;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingTemplateModel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.recordingconfiguration.PathElement;
import com.jrockit.mc.flightrecorder.controlpanel.ui.recordingconfiguration.PropertyContainer;
import com.jrockit.mc.rjmx.services.flr.EventOptionID;
import com.jrockit.mc.rjmx.services.flr.EventTypeID;
import com.jrockit.mc.rjmx.services.flr.IConvertibleValue;
import com.jrockit.mc.rjmx.services.flr.IEventSettingsHolder;
import com.jrockit.mc.rjmx.services.flr.IEventTypeInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public final class PropertyContentBuilder {
    private static final Map<String, String> LOCALIZED_PROPERTY_NAME = new HashMap<String, String>();
    private static final Pattern PATH_SPLIT_REGEX;
    private final IRecordingConfiguration m_recordingTemplate;
    private final IEventSettingsHolder m_serverEventSettings;
    private final Map<EventTypeID, IEventTypeInfo> m_eventTypeInfos;

    static {
        LOCALIZED_PROPERTY_NAME.put("enabled", Messages.LABEL_EVENT_ENABLED);
        LOCALIZED_PROPERTY_NAME.put("period", Messages.LABEL_EVENT_PERIOD);
        LOCALIZED_PROPERTY_NAME.put("stackTrace", Messages.LABEL_EVENT_STACK_TRACE);
        LOCALIZED_PROPERTY_NAME.put("threshold", Messages.LABEL_EVENT_THRESHOLD);
        PATH_SPLIT_REGEX = Pattern.compile("\\/");
    }

    private PropertyContentBuilder(IRecordingConfiguration recordingTemplate, IEventSettingsHolder serverEventSettings, Map<EventTypeID, IEventTypeInfo> eventTypeInfos) {
        this.m_recordingTemplate = recordingTemplate;
        this.m_serverEventSettings = serverEventSettings;
        this.m_eventTypeInfos = eventTypeInfos;
    }

    public static List<? extends PathElement> build(IRecordingConfiguration recordingTemplate, IEventSettingsHolder serverEventSettings, Map<EventTypeID, IEventTypeInfo> eventTypeInfos) {
        return new PropertyContentBuilder(recordingTemplate, serverEventSettings, eventTypeInfos).build();
    }

    public static List<? extends PathElement> build(RecordingTemplateModel model) {
        return PropertyContentBuilder.build(model.getTemplate(), model.getServerSettings(), model.getEventTypeInfos());
    }

    private List<? extends PathElement> build() {
        PropertyContainer.FolderNode dummyRootFolder = new PropertyContainer.FolderNode(null, null, null, PathElement.PathElementKind.IN_BOTH);
        this.addOptions(this.m_recordingTemplate.getEventOptions(), dummyRootFolder, PathElement.PathElementKind.IN_CONFIGURATION);
        if (this.m_serverEventSettings != null) {
            this.addOptions(this.m_serverEventSettings.getEventOptions(), dummyRootFolder, PathElement.PathElementKind.IN_SERVER);
        }
        return dummyRootFolder.getChildren();
    }

    private void addOptions(Map<EventOptionID, IConvertibleValue<?>> optionMap, PropertyContainer.FolderNode rootFolder, PathElement.PathElementKind kind) {
        for (Map.Entry<EventOptionID, IConvertibleValue<?>> optionEntry : optionMap.entrySet()) {
            EventOptionID eventOptionID = optionEntry.getKey();
            PropertyContainer.EventNode eventNode = this.findEventNode(rootFolder, eventOptionID.getEventTypeID(), kind);
            String value = optionEntry.getValue().toConfigString();
            eventNode.addToOption(eventOptionID.getOptionKey(), kind, value);
        }
    }

    private PropertyContainer.EventNode findEventNode(PropertyContainer.FolderNode folder, EventTypeID eventTypeID, PathElement.PathElementKind kind) {
        String[] splittedPath = PATH_SPLIT_REGEX.split(eventTypeID.getEventPath());
        int i = 0;
        while (i < splittedPath.length - 1) {
            folder = folder.createOrGetFolder(splittedPath[i], kind);
            ++i;
        }
        return folder.createOrGetEvent(eventTypeID, kind, this.m_eventTypeInfos);
    }

    public static String getLocalizedOptionName(String optionKey) {
        String localizedName = LOCALIZED_PROPERTY_NAME.get(optionKey);
        return localizedName != null ? localizedName : EventAppearance.humanifyName((String)optionKey);
    }
}

