/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.model;

import com.jrockit.mc.common.IMCFrame;
import com.jrockit.mc.common.IMCMethod;
import com.jrockit.mc.common.IMCStackTrace;
import com.jrockit.mc.flightrecorder.internal.model.FLRFrame;
import com.jrockit.mc.flightrecorder.internal.model.FLRMethod;
import com.jrockit.mc.flightrecorder.internal.parser.binary.factories.IHashable;
import com.jrockit.mc.flightrecorder.util.EqualsToolkit;
import java.util.ArrayList;
import java.util.List;

public final class FLRStackTrace
implements IMCStackTrace,
IHashable<FLRStackTrace> {
    private final List<FLRFrame> m_list;
    private final int m_hashCode;
    private final FLRFrame m_topFrame;
    private final FLRFrame m_almostThreadRootFrame;
    private final IMCStackTrace.TruncationState m_truncated;

    public FLRStackTrace(FLRFrame[] frames, Boolean truncated, boolean showHidden) {
        this.m_list = FLRStackTrace.buildFilteredStackTrace(frames, showHidden);
        this.m_topFrame = this.findTopFrame();
        this.m_hashCode = this.calcMethodHash();
        this.m_almostThreadRootFrame = this.findAlmostThreadRootFrame();
        this.m_truncated = IMCStackTrace.TruncationState.fromBoolean((Boolean)truncated);
    }

    private static List<FLRFrame> buildFilteredStackTrace(FLRFrame[] frames, boolean showHidden) {
        ArrayList<FLRFrame> list = new ArrayList<FLRFrame>(frames.length);
        FLRFrame[] fLRFrameArray = frames;
        int n = frames.length;
        int n2 = 0;
        while (n2 < n) {
            FLRFrame f = fLRFrameArray[n2];
            if (FLRStackTrace.includeMethod(f.getMethod(), showHidden)) {
                list.add(f);
            }
            ++n2;
        }
        list.trimToSize();
        return list;
    }

    private static boolean includeMethod(IMCMethod m, boolean showHidden) {
        if (m != null) {
            if (m.getPackageName() != null && m.getPackageName().startsWith("oracle.jrockit.jfr.")) {
                return false;
            }
            if (!showHidden && m instanceof FLRMethod && ((FLRMethod)m).isHidden()) {
                return false;
            }
        }
        return true;
    }

    private FLRFrame findAlmostThreadRootFrame() {
        if (this.m_list.size() > 2 && this.m_list.size() < 62) {
            return this.m_list.get(this.m_list.size() - 1);
        }
        return null;
    }

    private int calcMethodHash() {
        int hash = 23;
        int size = this.m_list.size();
        int n = 0;
        while (n < size) {
            IMCFrame a = (IMCFrame)this.m_list.get(n);
            if (a != null) {
                hash = EqualsToolkit.hash(hash, a.getMethod());
            }
            ++n;
        }
        return hash;
    }

    private FLRFrame findTopFrame() {
        if (this.m_list.size() > 0 && this.m_list.get(0) != null && this.m_list.get(0).getMethod() != null) {
            return this.m_list.get(0);
        }
        return null;
    }

    public FLRFrame getValidTopFrame() {
        return this.m_topFrame;
    }

    public FLRFrame getAlmostThreadRootFrame() {
        return this.m_almostThreadRootFrame;
    }

    public List<? extends IMCFrame> getFrames() {
        return this.m_list;
    }

    @Override
    public int calculateHashCode() {
        return this.m_hashCode;
    }

    @Override
    public boolean isEqual(FLRStackTrace t) {
        if (t == this) {
            return true;
        }
        List<? extends IMCFrame> thatFrames = t.getFrames();
        int thatSize = thatFrames.size();
        if (thatSize == this.m_list.size()) {
            int n = 0;
            while (n < thatSize) {
                IMCFrame a = (IMCFrame)this.m_list.get(n);
                IMCFrame b = thatFrames.get(n);
                if (a != null && b != null ? !EqualsToolkit.nullSafeEquals(a.getMethod(), b.getMethod()) || !EqualsToolkit.nullSafeEquals(a.getBCI(), b.getBCI()) || !EqualsToolkit.nullSafeEquals(a.getFrameLineNumber(), b.getFrameLineNumber()) || !EqualsToolkit.nullSafeEquals(a.getType(), b.getType()) : a != b) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    public IMCStackTrace.TruncationState getTruncationState() {
        return this.m_truncated;
    }
}

