/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.browser.wizards;

import com.jrockit.mc.browser.JVMBrowserPlugin;
import com.jrockit.mc.browser.views.BrowserLabelProvider;
import com.jrockit.mc.browser.views.Folder;
import com.jrockit.mc.browser.wizards.Messages;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.core.StatusFactory;
import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.rjmx.model.IServer;
import com.jrockit.mc.rjmx.model.internal.ServerModel;
import com.jrockit.mc.ui.misc.TreeStructureContentProvider;
import com.jrockit.mc.ui.wizards.ExportTreeToFileWizardPage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.w3c.dom.Document;

public class ConnectionExportWizard
extends Wizard
implements IExportWizard {
    private final ServerModel model = (ServerModel)RJMXPlugin.getDefault().getService(ServerModel.class);
    private ExportConnectionsToFile m_wizardPage;

    public boolean performFinish() {
        if (this.m_wizardPage.isExportToFileOk()) {
            try {
                IServer[] servers = this.filterOutNodes(this.m_wizardPage.getSelectedItems());
                XmlToolkit.storeDocumentToFile((Document)this.model.exportServers(servers), (File)this.m_wizardPage.getFile());
                this.m_wizardPage.storeFilename();
                return true;
            }
            catch (Exception e) {
                ErrorDialog.openError((Shell)this.getShell(), (String)Messages.ConnectionExportWizard_EXPORT_FILE_ERROR_TITLE, (String)(String.valueOf(Messages.ConnectionExportWizard_FILE_ERROR_EXPORT_TEXT) + "\n\n" + this.m_wizardPage.getFile()), (IStatus)StatusFactory.createErr((String)e.getMessage(), (Throwable)e, (boolean)true));
            }
        }
        return false;
    }

    protected IServer[] filterOutNodes(Collection<?> collection) {
        ArrayList<IServer> servers = new ArrayList<IServer>();
        for (Object next : collection) {
            if (!(next instanceof IServer)) continue;
            servers.add((IServer)next);
        }
        return servers.toArray(new IServer[servers.size()]);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setDialogSettings(JVMBrowserPlugin.getDefault().getDialogSettings());
        this.m_wizardPage = new ExportConnectionsToFile(Messages.ConnectionExportWizard_EXPORT_CONNECTIONS_WIZARD_PAGE_NAME);
        this.m_wizardPage.setTitle(Messages.ConnectionExportWizard_EXPORT_CONNECTIONS_TITLE);
        this.m_wizardPage.setMessage(Messages.ConnectionExportWizard_SELECTIONCONNECTIONS_TO_EXPORT);
        this.m_wizardPage.setImageDescriptor(JVMBrowserPlugin.getDefault().getMCImageDescriptor("bannerconwiz.gif"));
        this.setWindowTitle(Messages.ConnectionExportWizard_WIZARD_EXPORT_CONNECTION_TITLE);
        this.addPage((IWizardPage)this.m_wizardPage);
    }

    public boolean canFinish() {
        return this.m_wizardPage != null && this.m_wizardPage.isPageComplete();
    }

    private class ExportConnectionsToFile
    extends ExportTreeToFileWizardPage {
        private ExportConnectionsToFile(String pageName) {
            super(pageName, "xml");
        }

        protected void initializeViewer(TreeViewer viewer) {
            viewer.setAutoExpandLevel(2);
            viewer.setContentProvider((IContentProvider)new TreeStructureContentProvider());
            Folder root = new Folder(null, "root");
            IServer[] iServerArray = ConnectionExportWizard.this.model.elements();
            int n = iServerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IServer server = iServerArray[n2];
                if (server.getDiscoveryInfo() == null) {
                    root.getFolder(server.getPath()).addLeaf(server);
                }
                ++n2;
            }
            viewer.setInput((Object)root);
            viewer.setLabelProvider((IBaseLabelProvider)new BrowserLabelProvider());
        }
    }
}

